/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.status;

import de.maxhenkel.status.config.ServerConfig;
import de.maxhenkel.status.configbuilder.ConfigBuilder;
import de.maxhenkel.status.playerstate.PlayerStateManager;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Status
implements ModInitializer {
    public static final String MODID = "status";
    public static final Logger LOGGER = LogManager.getLogger((String)"status");
    @Nullable
    public static ServerConfig SERVER_CONFIG;
    public static PlayerStateManager STATE_MANAGER;
    public static final class_2960 INIT;
    public static int COMPATIBILITY_VERSION;

    public void onInitialize() {
        try {
            COMPATIBILITY_VERSION = Status.readCompatibilityVersion();
            LOGGER.info("Compatibility version {}", (Object)COMPATIBILITY_VERSION);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read compatibility version");
        }
        STATE_MANAGER = new PlayerStateManager();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            SERVER_CONFIG = ConfigBuilder.builder(ServerConfig::new).path(server.method_3831().toPath().resolve("config").resolve(MODID).resolve("status-server.properties")).build();
        });
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.writeInt(COMPATIBILITY_VERSION);
            sender.sendPacket(INIT, buffer);
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)INIT, (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (!understood) {
                return;
            }
            int clientCompatibilityVersion = buf.readInt();
            if (clientCompatibilityVersion != COMPATIBILITY_VERSION) {
                LOGGER.warn("Client {} has incompatible mod version (server={}, client={})", (Object)handler.method_14383(), (Object)COMPATIBILITY_VERSION, (Object)clientCompatibilityVersion);
                handler.method_14380((class_2561)class_2561.method_43469((String)"message.status.incompatible_version", (Object[])new Object[]{class_2561.method_43470((String)this.getModVersion()).method_27692(class_124.field_1067), class_2561.method_43470((String)this.getModName()).method_27692(class_124.field_1067)}));
            }
        });
    }

    public String getModVersion() {
        ModContainer modContainer = FabricLoader.getInstance().getModContainer(MODID).orElse(null);
        if (modContainer == null) {
            return "N/A";
        }
        return modContainer.getMetadata().getVersion().getFriendlyString();
    }

    public String getModName() {
        ModContainer modContainer = FabricLoader.getInstance().getModContainer(MODID).orElse(null);
        if (modContainer == null) {
            return MODID;
        }
        return modContainer.getMetadata().getName();
    }

    public static int readCompatibilityVersion() {
        ModContainer modContainer = FabricLoader.getInstance().getModContainer(MODID).orElse(null);
        if (modContainer == null) {
            return -1;
        }
        return Integer.parseInt(modContainer.getMetadata().getCustomValue(MODID).getAsObject().get("compatibilityVersion").getAsString());
    }

    static {
        INIT = new class_2960(MODID, "init");
        COMPATIBILITY_VERSION = -1;
    }
}

