/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.utils;

import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3341;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class GreenhouseCache {
    private static final HashMap<class_5321<class_1937>, HashMap<class_1923, ArrayList<GreenHouseTicket>>> CACHE = new HashMap();
    public static final int EXPIRATION_TIME = 5;
    private static int AGE;

    public static void add(class_1937 world, class_1923 chunkPos, GreenHouseTicket ticket) {
        class_5321 worldKey = world.method_27983();
        HashMap chunkTickets = CACHE.computeIfAbsent((class_5321<class_1937>)worldKey, k -> new HashMap());
        chunkTickets.computeIfAbsent(chunkPos, p -> new ArrayList()).add(ticket);
    }

    public static Season test(class_1937 world, class_2338 pos) {
        ArrayList<GreenHouseTicket> tickets;
        Season currentSeason = FabricSeasons.getCurrentSeason(world);
        HashSet<Season> seasons = new HashSet<Season>();
        class_5321 worldKey = world.method_27983();
        HashMap<class_1923, ArrayList<GreenHouseTicket>> chunkTickets = CACHE.get(worldKey);
        if (chunkTickets != null && (tickets = chunkTickets.get(new class_1923(pos))) != null) {
            Iterator<GreenHouseTicket> iterator = tickets.iterator();
            while (iterator.hasNext()) {
                GreenHouseTicket ticket = iterator.next();
                if (AGE > ticket.age + 5) {
                    ticket.expired = true;
                    iterator.remove();
                    continue;
                }
                seasons.addAll(ticket.test(pos));
            }
        }
        return seasons.stream().max(Comparator.comparingInt(Season::getTemperature)).orElse(currentSeason);
    }

    public static void tick(MinecraftServer server) {
        ++AGE;
    }

    public static class GreenHouseTicket {
        private final class_3341 box;
        public final Set<Season> seasons;
        public int age;
        public boolean expired;

        public GreenHouseTicket(class_3341 box, Season ... season) {
            this.box = box;
            this.seasons = new HashSet<Season>(List.of(season));
            this.age = AGE;
            this.expired = false;
        }

        public Set<Season> test(class_2338 pos) {
            if (this.box.method_14662((class_2382)pos)) {
                return this.seasons;
            }
            return Set.of();
        }
    }
}

