/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.bestylewither.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.morimori0317.bestylewither.BEStyleWither;
import net.morimori0317.bestylewither.config.BESConfig;
import org.apache.commons.io.FileUtils;

public class BEStyleWitherUtils {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean loadOrGenerateForgeBaseEnableDoubleHealth(File configFolder) {
        File configFile = new File(configFolder, "bestylewither-pre.json");
        if (!configFolder.exists() && !configFolder.mkdirs()) {
            BEStyleWither.LOGGER.error("Failed to create folder for pre config");
            return BESConfig.DEFAULT.isEnableDoubleHealth();
        }
        boolean generateJson = false;
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                boolean throwable2;
                try (BufferedReader bufReader222 = new BufferedReader(reader);){
                    JsonObject jo = (JsonObject)GSON.fromJson((Reader)bufReader222, JsonObject.class);
                    boolean ret = jo.get("Enable double health").getAsBoolean();
                    BEStyleWither.LOGGER.info("Pre config loading completed");
                    throwable2 = ret;
                }
                return throwable2;
            }
            catch (IOException e) {
                BEStyleWither.LOGGER.error("Failed to load pre config", (Throwable)e);
            }
            catch (JsonSyntaxException e) {
                BEStyleWither.LOGGER.error("Pre config is corrupted and will be regenerated", (Throwable)e);
                try {
                    File backupConfigFile = new File(configFolder, "bestylewither-pre_bk.json");
                    if (backupConfigFile.exists()) {
                        FileUtils.delete((File)backupConfigFile);
                    }
                    FileUtils.moveFile((File)configFile, (File)backupConfigFile);
                    generateJson = true;
                }
                catch (IOException ioe) {
                    BEStyleWither.LOGGER.error("Failed to backup corrupted pre config", (Throwable)ioe);
                }
            }
        } else {
            BEStyleWither.LOGGER.info("Generate pre config because it does not exist");
            generateJson = true;
        }
        if (generateJson) {
            JsonObject jo = new JsonObject();
            jo.addProperty("Enable double health", Boolean.valueOf(BESConfig.DEFAULT.isEnableDoubleHealth()));
            try (FileWriter writer = new FileWriter(configFile);
                 BufferedWriter bufWriter = new BufferedWriter(writer);){
                GSON.toJson((JsonElement)jo, (Appendable)bufWriter);
            }
            catch (IOException e) {
                BEStyleWither.LOGGER.error("Failed to generate pre config", (Throwable)e);
            }
        }
        return BESConfig.DEFAULT.isEnableDoubleHealth();
    }
}

