/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_169;
import net.minecraft.class_181;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_47;
import net.minecraft.class_5335;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.registry.LootrLootInit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootCount
implements class_5341 {
    private final List<Operation> operations;

    public LootCount(List<Operation> operations) {
        this.operations = operations;
    }

    @NotNull
    public class_5342 method_29325() {
        return LootrLootInit.LOOT_COUNT;
    }

    public boolean test(class_47 lootContext) {
        class_243 pos = (class_243)lootContext.method_296(class_181.field_24424);
        if (pos == null) {
            return false;
        }
        class_2338 position = class_2338.method_49638((class_2374)pos);
        class_2586 tileentity = lootContext.method_299().method_8321(position);
        if (tileentity instanceof ILootBlockEntity) {
            int count = ((ILootBlockEntity)tileentity).getOpeners().size() + 1;
            for (Operation op : this.operations) {
                if (op.test(count)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public Set<class_169<?>> method_293() {
        return ImmutableSet.of((Object)class_181.field_24424);
    }

    public static class Operation
    implements Predicate<Integer> {
        private final Operand operand;
        private final int value;

        public Operation(Operand operand, int value) {
            this.operand = operand;
            this.value = value;
        }

        public int getPrecedence() {
            return this.operand.getPrecedence();
        }

        @Override
        public boolean test(Integer integer) {
            return this.operand.test(integer, this.value);
        }

        public JsonObject serialize() {
            JsonObject result = new JsonObject();
            result.addProperty("type", this.operand.name().toLowerCase(Locale.ROOT));
            result.addProperty("value", (Number)this.value);
            return result;
        }

        public static Operation deserialize(JsonObject object) {
            String operand = object.get("type").getAsString();
            Operand op = Operand.fromString(operand);
            if (op == null) {
                throw new IllegalArgumentException("invalid operand for operation: " + operand);
            }
            return new Operation(op, object.get("value").getAsInt());
        }
    }

    public static enum Operand implements BiPredicate<Integer, Integer>
    {
        EQUALS(Integer::equals, 0),
        NOT_EQUALS((a, b) -> !a.equals(b), 0),
        LESS_THAN((a, b) -> a < b, 1),
        GREATER_THAN((a, b) -> a > b, 1),
        LESS_THAN_EQUALS((a, b) -> a <= b, 1),
        GREATER_THAN_EQUALS((a, b) -> a >= b, 1);

        private final BiPredicate<Integer, Integer> predicate;
        private final int precedence;

        private Operand(BiPredicate<Integer, Integer> predicate, int precedence) {
            this.predicate = predicate;
            this.precedence = precedence;
        }

        @Override
        public boolean test(Integer integer, Integer integer2) {
            return this.predicate.test(integer, integer2);
        }

        public int getPrecedence() {
            return this.precedence;
        }

        @Nullable
        public static Operand fromString(String name) {
            name = name.toUpperCase(Locale.ROOT);
            for (Operand o : Operand.values()) {
                if (!name.equals(o.name())) continue;
                return o;
            }
            return null;
        }
    }

    public static class Serializer
    implements class_5335<LootCount> {
        public void serialize(JsonObject object, LootCount count, JsonSerializationContext context) {
            JsonArray operations = new JsonArray();
            for (Operation op : count.operations) {
                operations.add((JsonElement)op.serialize());
            }
            object.add("operations", (JsonElement)operations);
        }

        @NotNull
        public LootCount deserialize(JsonObject object, JsonDeserializationContext context) {
            JsonArray objects = object.get("operations").getAsJsonArray();
            ArrayList<Operation> operations = new ArrayList<Operation>();
            for (JsonElement element : objects) {
                if (!element.isJsonObject()) {
                    throw new IllegalArgumentException("invalid operand for LootCount: " + element);
                }
                operations.add(Operation.deserialize(element.getAsJsonObject()));
            }
            operations.sort(Comparator.comparingInt(Operation::getPrecedence));
            return new LootCount(operations);
        }
    }
}

