/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import team.reborn.energy.api.EnergyStorage;

public class InternalEnergyStorage
extends SnapshotParticipant<Long>
implements EnergyStorage {
    public long amount = 0L;
    public long capacity;
    public final long maxReceive;
    public final long maxExtract;

    public InternalEnergyStorage(long capacity) {
        this(capacity, capacity, capacity);
    }

    public InternalEnergyStorage(long capacity, long maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public InternalEnergyStorage(long capacity, long maxReceive, long maxExtract) {
        StoragePreconditions.notNegative((long)capacity);
        StoragePreconditions.notNegative((long)maxReceive);
        StoragePreconditions.notNegative((long)maxExtract);
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public InternalEnergyStorage(long capacity, long maxReceive, long maxExtract, long energy) {
        this(capacity, maxReceive, maxExtract);
        this.amount = energy;
    }

    protected Long createSnapshot() {
        return this.amount;
    }

    protected void readSnapshot(Long snapshot) {
        this.amount = snapshot;
    }

    public class_2487 write(class_2487 nbt) {
        nbt.method_10544("energy", this.amount);
        return nbt;
    }

    public void read(class_2487 nbt) {
        this.setEnergy(nbt.method_10550("energy"));
    }

    public class_2487 write(class_2487 nbt, String name) {
        nbt.method_10544("energy_" + name, this.amount);
        return nbt;
    }

    public void read(class_2487 nbt, String name) {
        this.setEnergy(nbt.method_10550("energy_" + name));
    }

    public long getSpace() {
        return Math.max(this.getCapacity() - this.getAmount(), 0L);
    }

    public boolean supportsExtraction() {
        return this.maxExtract > 0L;
    }

    public boolean supportsInsertion() {
        return this.maxReceive > 0L;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long inserted = Math.min(this.maxReceive, Math.min(maxAmount, this.capacity - this.amount));
        if (inserted > 0L) {
            this.updateSnapshots(transaction);
            this.amount += inserted;
            return inserted;
        }
        return 0L;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long extracted = Math.min(this.maxExtract, Math.min(maxAmount, this.amount));
        if (extracted > 0L) {
            this.updateSnapshots(transaction);
            this.amount -= extracted;
            return extracted;
        }
        return 0L;
    }

    public long simulateExtract(long maxAmount) {
        try (Transaction t = TransferUtil.getTransaction();){
            StoragePreconditions.notNegative((long)maxAmount);
            long extracted = Math.min(this.maxExtract, Math.min(maxAmount, this.amount));
            if (extracted > 0L) {
                this.updateSnapshots((TransactionContext)t);
                this.amount -= extracted;
                long l = extracted;
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    public long internalConsumeEnergy(long consume) {
        long oenergy = this.amount;
        this.amount = Math.max(0L, this.amount - consume);
        return oenergy - this.amount;
    }

    public long internalProduceEnergy(long produce) {
        long oenergy = this.amount;
        this.amount = Math.min(this.capacity, this.amount + produce);
        return oenergy - this.amount;
    }

    public void setEnergy(long energy) {
        this.amount = energy;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getCapacity() {
        return this.capacity;
    }

    @Deprecated
    public void outputToSide(class_1937 world, class_2338 pos, class_2350 side, int max) {
        EnergyStorage ies = (EnergyStorage)EnergyStorage.SIDED.find(world, pos.method_10093(side), (Object)side.method_10153());
        if (ies == null) {
            return;
        }
        try (Transaction t = Transaction.openOuter();){
            long ext = this.extract(max, (TransactionContext)t);
            this.insert(ext - ies.insert(ext, (TransactionContext)t), (TransactionContext)t);
            t.commit();
        }
    }

    public String toString() {
        return this.getAmount() + "/" + this.getCapacity() + " <-" + this.maxExtract + " ->" + this.maxReceive;
    }
}

