/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.blocks.connector.ConnectorType;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.WireConnectResult;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.item.WireSpool;
import com.mrh0.createaddition.util.Util;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IWireNode {
    @Nullable
    public IWireNode getWireNode(int var1);

    @Nullable
    public static IWireNode getWireNodeFrom(int index, IWireNode obj, LocalNode[] localNodes, IWireNode[] nodeCache, class_1937 level) {
        if (!obj.hasConnection(index)) {
            return null;
        }
        if (nodeCache[index] == null) {
            nodeCache[index] = IWireNode.getWireNode(level, localNodes[index].getPos());
        }
        if (nodeCache[index] == null) {
            obj.removeNode(index);
        }
        return nodeCache[index];
    }

    @Nullable
    public LocalNode getLocalNode(int var1);

    public void setNode(int var1, int var2, class_2338 var3, WireType var4);

    public void removeNode(int var1, boolean var2);

    default public void removeNode(int index) {
        this.removeNode(index, false);
    }

    default public void removeNode(LocalNode node, boolean dropWire) {
        this.removeNode(node.getIndex(), dropWire);
    }

    default public void removeNode(@NotNull LocalNode node) {
        this.removeNode(node.getIndex());
    }

    default public int getNodeCount() {
        return 1;
    }

    default public int getAvailableNode(class_243 pos) {
        return this.getAvailableNode();
    }

    default public int getAvailableNode() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    default public class_2338 getNodePos(int index) {
        LocalNode node = this.getLocalNode(index);
        if (node == null) {
            return null;
        }
        return node.getPos();
    }

    @Nullable
    default public WireType getNodeType(int index) {
        LocalNode node = this.getLocalNode(index);
        if (node == null) {
            return null;
        }
        return node.getType();
    }

    default public int getOtherNodeIndex(int index) {
        LocalNode node = this.getLocalNode(index);
        if (node == null) {
            return -1;
        }
        return node.getOtherIndex();
    }

    default public boolean hasConnection(int index) {
        return this.getLocalNode(index) != null;
    }

    default public boolean hasAnyConnection() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!this.hasConnection(i)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasConnectionTo(class_2338 pos) {
        if (pos == null) {
            return false;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode node = this.getLocalNode(i);
            if (node == null || !node.getPos().equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public LocalNode getConnectionTo(class_2338 pos) {
        if (pos == null) {
            return null;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode node = this.getLocalNode(i);
            if (node == null || !node.getPos().equals((Object)pos)) continue;
            return node;
        }
        return null;
    }

    default public boolean isNodeInput(int index) {
        return true;
    }

    default public boolean isNodeOutput(int node) {
        return true;
    }

    public class_243 getNodeOffset(int var1);

    public class_2338 getPos();

    public void invalidateNodeCache();

    public void setNetwork(int var1, EnergyNetwork var2);

    public EnergyNetwork getNetwork(int var1);

    default public boolean awakeNetwork(class_1937 world) {
        boolean b = false;
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.isNetworkValid(i)) continue;
            this.setNetwork(i, EnergyNetwork.nextNode(world, new EnergyNetwork(world), new HashMap<String, IWireNode>(), this, i));
            b = true;
        }
        return b;
    }

    default public boolean isNetworkValid(int node) {
        if (this.getNetwork(node) == null) {
            return false;
        }
        return this.getNetwork(node).isValid();
    }

    default public boolean isNodeIndeciesConnected(int in, int other) {
        return true;
    }

    default public boolean validateLocalNodes(LocalNode[] localNodes) {
        boolean changed = false;
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            if (localNodes[i] == null || (otherNode = this.getWireNode(i)) == null || otherNode.hasConnectionTo(this.getPos())) continue;
            changed = true;
            localNodes[i] = null;
        }
        return changed;
    }

    default public void convertOldNbt(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!nbt.method_10545("node" + i)) continue;
            if (nbt.method_10550("node" + i) == -1) {
                nbt.method_10551("node" + i);
                nbt.method_10551("type" + i);
                continue;
            }
            int other = nbt.method_10550("node" + i);
            WireType type = WireType.fromIndex(nbt.method_10550("type" + i));
            class_2338 pos = new class_2338(nbt.method_10550("x" + i), nbt.method_10550("y" + i), nbt.method_10550("z" + i)).method_10059((class_2382)this.getPos());
            nbt.method_10551("node" + i);
            nbt.method_10551("type" + i);
            nbt.method_10551("x" + i);
            nbt.method_10551("y" + i);
            nbt.method_10551("z" + i);
            class_2487 tag = new class_2487();
            tag.method_10569("id", i);
            tag.method_10569("other", other);
            tag.method_10569("type", type.getIndex());
            tag.method_10569("x", pos.method_10263());
            tag.method_10569("y", pos.method_10264());
            tag.method_10569("z", pos.method_10260());
            list.add((Object)tag);
        }
        nbt.method_10566("nodes", (class_2520)list);
    }

    default public void handleWireCache(class_1937 level, Set<LocalNode> toDrop) {
        toDrop.forEach(node -> this.dropWire(level, (LocalNode)node));
        toDrop.clear();
    }

    default public void disconnectWires() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode node = this.getLocalNode(i);
            if (node == null) continue;
            node.invalid();
        }
    }

    default public void dropWire(class_1937 world, LocalNode node) {
        WireType type = node.getType();
        class_1799 wire = type.getDrop();
        node.invalid();
        IWireNode.dropWire(world, this.getPos(), wire);
    }

    default public void dropWires(class_1937 world, boolean dropItems) {
        if (!dropItems) {
            this.disconnectWires();
            return;
        }
        class_2371 wires = class_2371.method_10213((int)WireType.values().length, (Object)class_1799.field_8037);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode node = this.getLocalNode(i);
            if (node == null) continue;
            WireType type = node.getType();
            int index = type.getIndex();
            if (((class_1799)wires.get(index)).method_7960()) {
                wires.set(index, (Object)type.getDrop());
            } else {
                ((class_1799)wires.get(index)).method_7933(type.getDrop().method_7947());
            }
            node.invalid();
        }
        for (class_1799 stack : wires) {
            IWireNode.dropWire(world, this.getPos(), stack);
        }
    }

    default public void dropWires(class_1937 world, class_1657 player, boolean dropItems) {
        if (!dropItems) {
            this.disconnectWires();
            return;
        }
        class_2371 wireSpools = class_2371.method_10213((int)WireType.values().length, (Object)class_1799.field_8037);
        class_2371 wires = class_2371.method_10213((int)WireType.values().length, (Object)class_1799.field_8037);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode node = this.getLocalNode(i);
            if (node == null) continue;
            WireType type = node.getType();
            int index = type.getIndex();
            class_1799 spools = Util.findStack(((WireSpool)((Object)CAItems.SPOOL.get())).method_8389(), player.method_31548());
            if (spools.method_7947() > 0) {
                if (((class_1799)wireSpools.get(index)).method_7960()) {
                    wireSpools.set(index, (Object)type.getSourceDrop());
                } else {
                    ((class_1799)wireSpools.get(index)).method_7933(type.getSourceDrop().method_7947());
                }
                spools.method_7934(1);
            } else if (((class_1799)wires.get(index)).method_7960()) {
                wires.set(index, (Object)type.getDrop());
            } else {
                ((class_1799)wires.get(index)).method_7933(type.getDrop().method_7947());
            }
            node.invalid();
        }
        for (class_1799 stack : wireSpools) {
            if (stack.method_7960()) continue;
            IWireNode.dropWire(world, this.getPos(), player.method_31548().method_7394(stack) ? class_1799.field_8037 : stack);
        }
        for (class_1799 stack : wires) {
            if (stack.method_7960()) continue;
            IWireNode.dropWire(world, this.getPos(), player.method_31548().method_7394(stack) ? class_1799.field_8037 : stack);
        }
    }

    public ConnectorType getConnectorType();

    @Nullable
    public static class_2338 readNodeBlockPos(class_2487 nbt, int index, class_2338 origin) {
        class_2487 node = IWireNode.getNbtNode(nbt, index);
        if (node == null) {
            return null;
        }
        return origin.method_10069(node.method_10550("x"), node.method_10550("y"), node.method_10550("z"));
    }

    public static WireType readNodeWireType(class_2487 nbt, int index) {
        class_2487 node = IWireNode.getNbtNode(nbt, index);
        if (node == null) {
            return null;
        }
        return WireType.fromIndex(node.method_10550("type"));
    }

    public static int readNodeOtherIndex(class_2487 nbt, int index) {
        class_2487 node = IWireNode.getNbtNode(nbt, index);
        if (node == null) {
            return -1;
        }
        return node.method_10550("other");
    }

    @Nullable
    public static class_2487 getNbtNode(class_2487 nbt, int index) {
        if (!nbt.method_10545("nodes")) {
            return null;
        }
        class_2499 nodes = nbt.method_10554("nodes", 10);
        for (class_2520 t : nodes) {
            class_2487 node = (class_2487)t;
            if (node.method_10550("id") != index) continue;
            return node;
        }
        return null;
    }

    public int getMaxWireLength();

    public static WireConnectResult connect(class_1937 world, class_2338 pos1, int node1, class_2338 pos2, int node2, WireType type) {
        IWireNode wn1;
        class_2586 te2;
        block9: {
            block8: {
                class_2586 te1 = world.method_8321(pos1);
                te2 = world.method_8321(pos2);
                if (te1 == null || te2 == null || te1 == te2) {
                    return WireConnectResult.INVALID;
                }
                if (!(te1 instanceof IWireNode)) break block8;
                wn1 = (IWireNode)te1;
                if (te2 instanceof IWireNode) break block9;
            }
            return WireConnectResult.INVALID;
        }
        IWireNode wn2 = (IWireNode)te2;
        if (node1 < 0 || node2 < 0) {
            return WireConnectResult.COUNT;
        }
        int maxLength = Math.min(wn1.getMaxWireLength(), wn2.getMaxWireLength());
        if (pos1.method_10262((class_2382)pos2) > (double)(maxLength * maxLength)) {
            return WireConnectResult.LONG;
        }
        if (wn1.hasConnectionTo(pos2)) {
            return WireConnectResult.EXISTS;
        }
        if (wn1.getConnectorType() == ConnectorType.Large && wn2.getConnectorType() == ConnectorType.Large && type == WireType.COPPER) {
            return WireConnectResult.REQUIRES_HIGH_CURRENT;
        }
        wn1.setNode(node1, node2, wn2.getPos(), type);
        wn2.setNode(node2, node1, wn1.getPos(), type);
        return WireConnectResult.getLink(wn2.isNodeInput(node2), wn2.isNodeOutput(node2));
    }

    public static WireConnectResult disconnect(class_1937 world, class_2338 pos1, class_2338 pos2) {
        IWireNode wn1;
        class_2586 te2;
        block7: {
            block6: {
                class_2586 te1 = world.method_8321(pos1);
                te2 = world.method_8321(pos2);
                if (te1 == null || te2 == null || te1 == te2) {
                    return WireConnectResult.INVALID;
                }
                if (!(te1 instanceof IWireNode)) break block6;
                wn1 = (IWireNode)te1;
                if (te2 instanceof IWireNode) break block7;
            }
            return WireConnectResult.INVALID;
        }
        IWireNode wn2 = (IWireNode)te2;
        if (!wn1.hasConnectionTo(pos2)) {
            return WireConnectResult.NO_CONNECTION;
        }
        LocalNode ln1 = wn1.getConnectionTo(pos2);
        LocalNode ln2 = wn2.getConnectionTo(pos1);
        if (ln1 == null || ln2 == null) {
            return WireConnectResult.NO_CONNECTION;
        }
        wn1.removeNode(ln1);
        wn2.removeNode(ln2);
        return WireConnectResult.REMOVED;
    }

    @Nullable
    public static WireType getTypeOfConnection(class_1937 world, class_2338 pos1, class_2338 pos2) {
        class_2586 te1 = world.method_8321(pos1);
        if (te1 == null) {
            return null;
        }
        if (!(te1 instanceof IWireNode)) {
            return null;
        }
        IWireNode wn = (IWireNode)te1;
        LocalNode ln = wn.getConnectionTo(pos2);
        if (ln == null) {
            return null;
        }
        return ln.getType();
    }

    public static IWireNode getWireNode(class_1937 world, class_2338 pos) {
        if (pos == null) {
            return null;
        }
        class_2586 te = world.method_8321(pos);
        if (te == null) {
            return null;
        }
        if (!(te instanceof IWireNode)) {
            return null;
        }
        return (IWireNode)te;
    }

    public static void dropWire(class_1937 world, class_2338 pos, class_1799 stack) {
        class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)class_2371.method_10212((Object)class_1799.field_8037, (Object[])new class_1799[]{stack}));
    }
}

